# ==============================================================================
# Use of the this file and the contents are governed by an agreement between
# Technicolor Connected Home USA LLC (now known as Vantiva USA LLC) and Comcast
# Cable Communications Management, LLC.
#
# The contents of this file contain Vantiva Pre-Existing IP or third-party
# software, including open source software, and in accordance with the terms in
# place between Vantiva and Comcast, ownership of such IP will not transfer to
# Comcast by virtue of its inclusion in this repository.
#
# In addition the contents of this file can only be used on Comcast devices
# identified as XB10. No other uses are permitted for any other purpose or
# device.
# ==============================================================================
DESCRIPTION = "Files to init things for read-only file system"

FILESEXTRAPATHS_prepend := "${THISDIR}/files:"

SRC_URI_append_dunfell = " file://systemctl-reboot-trace_dunfell.patch"
SRC_URI_append_kirkstone = " file://systemctl-reboot-trace_kirkstone.patch"

SRC_URI += " \
            file://50-panic.conf \
            file://50-disable-coredump.conf \
            ${@bb.utils.contains('DISTRO_FEATURES','kirkstone',' file://timedatectl_sync_status_kirkstone.patch ',' file://timedatectl_sync_status.patch ',d)} \
           "

# Enable Core Dump control at user space.
EXTRA_OECONF_remove = " --disable-coredump"

VOLATILE_DIRS = "\
    /var/volatile/lib /var/lib\n\
    /var/volatile/dibbler /opt/dibbler\n\
    /tmp/dibbler /etc/dibbler\n\
    /var/volatile/media /media\n\
    /var/volatile/spoolcron /var/spool/cron\n\
    /var/volatile/www /www\n\
    /var/volatile/xupnp /etc/xupnp\n\
    /var/volatile/rdklogs /rdklogs size=10m\n\
    /var/volatile/minidumps /minidumps size=2m\n\
"

VOLATILE_FILES = "\
    /etc/fan_config\n\
    /etc/log4crc\n\
    /etc/ti_syslog.conf\n\
    /etc/zebra.conf\n\
    /etc/ssmtp.conf\n\
    /etc/resolv.conf\n\
    /etc/asound.conf\n\
    /etc/resolv.dnsmasq\n\
    /etc/hosts\n\
    /etc/hostname\n\
    /etc/dhcp_static_hosts\n\
    /etc/snmp/snmpd.conf\n\
    /etc/systemd/timesyncd.conf\n\
    /etc/udhcpc.vendor_specific\n\
"

do_install_append() {
    rm -f ${D}${base_libdir}/udev/rules.d/80-drivers.rules

    # Remove unwanted systemd services
    if [ -n "${@bb.utils.contains('PACKAGECONFIG', 'timesyncd', 'timesyncd', '', d)}" ]; then
        # rm ${D}${sysconfdir}/systemd/system/sysinit.target.wants/systemd-timesyncd.service
        rm ${D}${systemd_unitdir}/system/systemd-timesyncd.service
        rm ${D}/lib/systemd/systemd-timesyncd
        sed -i -- 's:enable systemd-timesyncd.service:disable systemd-timesyncd.service:g' ${D}/lib/systemd/system-preset/90-systemd.preset
    fi

    install -m 644 ${WORKDIR}/50-panic.conf ${D}${sysconfdir}/sysctl.d
    sed -i -e 's/^#DefaultRestartSec=.*$/DefaultRestartSec=10s/g' ${D}${sysconfdir}/systemd/system.conf
    sed -i -e 's/^#DefaultStartLimitInterval=.*$/DefaultStartLimitInterval=10s/g' ${D}${sysconfdir}/systemd/system.conf

    sed -i -- '/put=tty/d' ${D}/lib/systemd/system/getty@.service  

    # Disable coredump since minidump is preferred
    install -m 755 ${WORKDIR}/50-disable-coredump.conf ${D}${sysconfdir}/sysctl.d/

    # Create mount points in case od read-only
    # file system.
	while read spec mountpoint; do
        if [ -z "$spec" ]; then
            continue
        fi

        echo "L+ $spec - - - - ../var/volatile$spec" >> ${D}/usr/lib/tmpfiles.d/etc.conf
    done <<END
${@d.getVar('VOLATILE_FILES', True).replace("\\n", "\n")}
END

    while read spec mountpoint options; do
        if [ -z "$spec" ]; then
            continue
        fi

        if [[ "$mountpoint" != *.* ]];then
            install -d 0755 ${D}"$mountpoint"
        fi
    done <<END
${@d.getVar('VOLATILE_DIRS', True).replace("\\n", "\n")}
END
}

# Enable coredump config in rootfs
CONFFILES_${PN} += "${sysconfdir}/systemd/coredump.conf"

# Coredump list and backtrace on missed minidumps.
FILES_${PN} += "${bindir}/coredumpctl"
FILES_${PN} += "/opt /rdklogs /www /media /minidumps /etc/dibbler /etc/xupnp"

# Add timedated to enable timedatectl
PACKAGECONFIG[timedated] = "--enable-timedated"

# Add localed to enable localectl
PACKAGECONFIG[localed] = "--enable-localed"
